// Ole.h: interface for the Ole class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OLE_H__AE5FDFE1_72BA_11D5_A6C2_00207819DA39__INCLUDED_)
#define AFX_OLE_H__AE5FDFE1_72BA_11D5_A6C2_00207819DA39__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <ole2.h>

#include "BagGlue.h"
#include "DeleteFiles.h"

class Ole;

interface BagToolDS : public IDropSource
{
public:
	BagToolDS();
	virtual ~BagToolDS();

	HRESULT STDMETHODCALLTYPE GiveFeedback(DWORD dwEffect);
	HRESULT STDMETHODCALLTYPE QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState);
	
	HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR* ppv);
	ULONG STDMETHODCALLTYPE AddRef (){count++;return count;};
	ULONG STDMETHODCALLTYPE Release (){count--;if (count == 0) delete this;return count;};

	ULONG count;
	DWORD mousekey;
};

class BagToolEF : public IEnumFORMATETC
{
public:
	BagToolEF();
	virtual ~BagToolEF();

	static BagToolEF FAR * Create() {BagToolEF FAR * lpEF = new BagToolEF;return lpEF;};

	HRESULT STDMETHODCALLTYPE Next(ULONG celt, FORMATETC * rgelt, ULONG * pceltFetched);
	HRESULT STDMETHODCALLTYPE Skip(ULONG celt);
	HRESULT STDMETHODCALLTYPE Reset(void);
	HRESULT STDMETHODCALLTYPE Clone(IEnumFORMATETC ** ppenum);

	ULONG index;
	ULONG max;
	FORMATETC gelt[5];

	HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR* ppv);
	ULONG STDMETHODCALLTYPE AddRef (){count++;return count;};
	ULONG STDMETHODCALLTYPE Release (){count--;if (count == 0) delete this;return count;};

	ULONG count;
};

class BagToolDO : public IDataObject
{
public:
	BagToolDO();
	virtual ~BagToolDO();

	static BagToolDO FAR * Create(bool bOleInit, Ole * ole);

	HRESULT STDMETHODCALLTYPE GetData(FORMATETC * pFormatetc, STGMEDIUM * pmedium);
	HRESULT STDMETHODCALLTYPE GetDataHere(FORMATETC * pFormatetc, STGMEDIUM * pmedium);
	HRESULT STDMETHODCALLTYPE QueryGetData(FORMATETC * pFormatetc);
	HRESULT STDMETHODCALLTYPE GetCanonicalFormatEtc(FORMATETC *pformatectIn, FORMATETC  *pformatetcOut) {return E_NOTIMPL;};
	HRESULT STDMETHODCALLTYPE SetData(FORMATETC *pformatetc, STGMEDIUM *pmedium, BOOL fRelease) {return E_NOTIMPL;};
	HRESULT STDMETHODCALLTYPE EnumFormatEtc(DWORD dwDirection, IEnumFORMATETC **ppenumFormatEtc);
	HRESULT STDMETHODCALLTYPE DAdvise(FORMATETC *pformatetc, DWORD advf, IAdviseSink *pAdvSink, DWORD *pdwConnection) {return E_NOTIMPL;};
    HRESULT STDMETHODCALLTYPE DUnadvise(DWORD dwConnection) {return E_NOTIMPL;};
	HRESULT STDMETHODCALLTYPE EnumDAdvise(IEnumSTATDATA **ppenumAdvise) {return E_NOTIMPL;};

	bool bOleInitialized;

	HRESULT STDMETHODCALLTYPE QueryInterface (REFIID riid, LPVOID FAR* ppv);
	ULONG STDMETHODCALLTYPE AddRef (){count++;return count;};
	ULONG STDMETHODCALLTYPE Release (){count--;if (count == 0) delete this;return count;};

	HRESULT WriteMemory(HGLOBAL hMem);

	ULONG count;

	BagToolEF FAR * BGef;

	Ole * ole;
};

class Ole  
{
public:
	Ole();
	virtual ~Ole();

	bool Initialize();
	bool DoDragDrop(unsigned int i, BagGlue * bag, DWORD mousekey);
	
	unsigned int index;
	char * data;
	char * filename;
	DWORD filesize;

	void * pvReserved;
	bool bOleInitialized;

	BagToolDS FAR * BGds;
	BagToolDO FAR * BGdo;

	FILEGROUPDESCRIPTORA fdd;

	BagGlue * BG;
};

#endif // !defined(AFX_OLE_H__AE5FDFE1_72BA_11D5_A6C2_00207819DA39__INCLUDED_)
