// BagTool.cpp : Defines the entry point for the application.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "BagTool.h"

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	HWND hwnd;
	HACCEL haccel;
 	WNDCLASSEX wc;
	MSG msg;
	INITCOMMONCONTROLSEX initCtrls;
	RECT rc, rcStatus;
	int parts[3];
	TBBUTTON tbbutton[9];

	hthread = NULL;
	hwnddlg = NULL;

	wc.hInstance = ghInstance = hInstance;
	wc.lpszClassName = szWinClass;
	wc.lpfnWndProc = WndProc;
	wc.style = 0;
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
	wc.hIconSm = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.lpszMenuName = MAKEINTRESOURCE(IDR_MENU1);
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hbrBackground = (HBRUSH)(COLOR_MENU+1);
	if (!RegisterClassEx(&wc)) return 0;

	hwnd = CreateWindowEx(WS_EX_ACCEPTFILES, szWinClass, "Bag Tool version 0.3", 
		WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, 600, 440, HWND_DESKTOP, 
		NULL, hInstance, NULL);

	if (hwnd == NULL)
	{
		UnregisterClass(szWinClass, hInstance);
		return 0;
	}

	haccel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDR_ACCELERATOR1));

	initCtrls.dwSize = sizeof(LPINITCOMMONCONTROLSEX);
	initCtrls.dwICC = ICC_LISTVIEW_CLASSES | ICC_BAR_CLASSES;
	InitCommonControlsEx(&initCtrls);

	tbbutton[0].iBitmap = 0;
	tbbutton[0].idCommand = ID_FILE_READ;
	tbbutton[0].fsState = TBSTATE_ENABLED;
	tbbutton[0].fsStyle = TBSTYLE_BUTTON;
	tbbutton[0].dwData = 0;
	tbbutton[0].iString = 0;

	tbbutton[1].iBitmap = 1;
	tbbutton[1].idCommand = ID_FILE_ADD;
	tbbutton[1].fsState = TBSTATE_ENABLED;
	tbbutton[1].fsStyle = TBSTYLE_BUTTON;
	tbbutton[1].dwData = 1;
	tbbutton[1].iString = 1;

	tbbutton[2].iBitmap = 2;
	tbbutton[2].idCommand = ID_FILE_MP3;
	tbbutton[2].fsState = TBSTATE_ENABLED;
	tbbutton[2].fsStyle = TBSTYLE_BUTTON;
	tbbutton[2].dwData = 2;
	tbbutton[2].iString = 2;

	tbbutton[3].iBitmap = 3;
	tbbutton[3].idCommand = ID_FILE_CLEAR;
	tbbutton[3].fsState = TBSTATE_ENABLED;
	tbbutton[3].fsStyle = TBSTYLE_BUTTON;
	tbbutton[3].dwData = 3;
	tbbutton[3].iString = 3;

	tbbutton[4].iBitmap = 0;
	tbbutton[4].idCommand = 0;
	tbbutton[4].fsState = TBSTATE_ENABLED;
	tbbutton[4].fsStyle = TBSTYLE_SEP;
	tbbutton[4].dwData = 4;
	tbbutton[4].iString = 4;

	tbbutton[5].iBitmap = 4;
	tbbutton[5].idCommand = ID_FILE_WRITE;
	tbbutton[5].fsState = 0;
	tbbutton[5].fsStyle = TBSTYLE_BUTTON;
	tbbutton[5].dwData = 5;
	tbbutton[5].iString = 5;

	tbbutton[6].iBitmap = 5;
	tbbutton[6].idCommand = ID_EDIT_EXTRACT;
	tbbutton[6].fsState = 0;
	tbbutton[6].fsStyle = TBSTYLE_BUTTON;
	tbbutton[6].dwData = 6;
	tbbutton[6].iString = 6;

	
	tbbutton[7].iBitmap = 6;
	tbbutton[7].idCommand = ID_EDIT_DELETE;
	tbbutton[7].fsState = 0;
	tbbutton[7].fsStyle = TBSTYLE_BUTTON;
	tbbutton[7].dwData = 7;
	tbbutton[7].iString = 7;

	hwndtoolbar = CreateToolbarEx(hwnd, WS_CHILD | WS_VISIBLE | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS,
		200, 7, hInstance, IDR_TOOLBAR1, tbbutton, 8, 0, 0, 32, 32, 
		sizeof(TBBUTTON));
	SendMessage(hwndtoolbar, TB_AUTOSIZE, 0, 0);

	LoadString(hInstance, ID_FILE_ADD, stradd, 70);
	LoadString(hInstance, ID_FILE_READ, strread, 70);
	wsprintf(strmp3, "Adds the track information from an audio file");
	LoadString(hInstance, ID_FILE_CLEAR, strclear, 70);
	LoadString(hInstance, ID_FILE_WRITE, strwrite, 70);
	LoadString(hInstance, ID_EDIT_EXTRACT, strextract, 70);
	LoadString(hInstance, ID_EDIT_DELETE, strdelete, 70);
		
	GetClientRect(hwnd, &rc);

	hwndstatus = CreateStatusWindow( SBARS_SIZEGRIP | WS_CHILD | WS_VISIBLE | SBT_TOOLTIPS,
		"Ready", hwnd, 0);

	parts[0] = rc.right / 3;
	parts[1] = rc.right / 3 * 2;
	parts[2] = -1;

	SendMessage(hwndstatus, SB_SETPARTS, (WPARAM) 3, (LPARAM) parts);
	SendMessage(hwndstatus, SB_GETRECT, (WPARAM) 0, (LPARAM) &rcStatus);
	SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 0, (LPARAM) "Ready");
	
	totalbytes = 0;
	totaltracks = 0;
	SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 1, (LPARAM) "Total Size = 0 bytes");
	SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 2, (LPARAM) "Number of tracks = 0");
	SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 1, (LPARAM) "Total Size = 0 bytes");
	SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 2, (LPARAM) "Number of tracks = 0");

	hwndlist = CreateWindowEx(WS_EX_CLIENTEDGE, WC_LISTVIEW, (LPCTSTR) NULL, 
		WS_VISIBLE | WS_CHILD | LVS_REPORT | LVS_SINGLESEL,
		0, 41, rc.right, rc.bottom - rcStatus.bottom - 41, 
		hwnd, (HMENU) NULL, hInstance, (LPVOID) NULL);

	ListView_SetExtendedListViewStyle(hwndlist, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

	ListView_DoInsertColumn(hwndlist, 0, rc.right - 405, "Filename");
	ListView_DoInsertColumn(hwndlist, 0, 100, "Length");
	ListView_DoInsertColumn(hwndlist, 0, 100, "Frequency");
	ListView_DoInsertColumn(hwndlist, 0, 150, "Track Name");
	ListView_DoInsertColumn(hwndlist, 0, 50, "Index");

	hpopup = LoadMenu(hInstance, MAKEINTRESOURCE(IDR_MENU2));
	iPopup = 0;

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	DragAcceptFiles(hwnd, TRUE);

	ole.Initialize();

	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator( hwnd, haccel, &msg ))
			TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	DestroyMenu(hpopup);
	UnregisterClass(szWinClass, hInstance);
	WinHelp(hwnd, "BagTool.hlp", HELP_QUIT, 0);
	return msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	OPENFILENAME ofn;
	char data[50];
	unsigned int total, i, j;
	RECT rc;
	POINT pt;
	LPTOOLTIPTEXT lpttt;

	switch(uMsg)
	{
	case WM_DROPFILES:
		total = DragQueryFile((HDROP) wParam, 0xFFFFFFFF, NULL, 0);
		i = 0;
		while (i < total)
		{
			szFile[0] = 0;
			DragQueryFile((HDROP) wParam, i, szFile, 128);
			if (!AddFiles(hwnd, szFile))
				break;
			i++;
		}
		SendMessage(hwndtoolbar, TB_SETSTATE, ID_FILE_WRITE, MAKELONG(TBSTATE_ENABLED, 0));
		SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_EXTRACT, MAKELONG(TBSTATE_ENABLED, 0));
		SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_DELETE, MAKELONG(TBSTATE_ENABLED, 0));
		DragFinish((HDROP) wParam);
		break;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case ID_POPUP_CANCEL:
			break;
		case ID_POPUP_PROPERTIES:
			DialogBoxParam(ghInstance, MAKEINTRESOURCE(IDD_DIALOG2), 
					hwnd, (DLGPROC) DlgProc2, iPopup);
			break;
		case ID_FILE_CLEAR:
			ListView_DeleteAllItems(hwndlist);
			bag.Close();
			totalbytes = 0;
			totaltracks = 0;
			wsprintf(data, "Total Size = %u bytes", totalbytes);
			SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 1, (LPARAM) data);
			SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 1, (LPARAM) data);
			wsprintf(data, "Number of tracks = %u", totaltracks);
			SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 2, (LPARAM) data);
			SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 2, (LPARAM) data);
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_FILE_WRITE, 0);
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_EXTRACT, 0);
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_DELETE, 0);
			break;
		case ID_FILE_READ:
			szFile[0] = 0;
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = "Bag Files (*.bag)\0*.BAG\0All (*.*)\0*.*\0\0";
			ofn.nFilterIndex = 1;
			ofn.nMaxFileTitle = NULL;
			ofn.lpstrFileTitle = NULL;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Select a bag file to read";
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY; 
			if (GetOpenFileName(&ofn) != TRUE)
				break;
			if (!bag.Read(szFile))
			{
				MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
				break;
			}
			ListView_DeleteAllItems(hwndlist);
			total = bag.GetTotalTracks();
			i = 0;
			while (i < total)
			{
				wsprintf(data, "%u", i + 1);
				ListView_DoInsertItem(hwndlist, i, data);
				ListView_DoSetItem(hwndlist, i, 1, bag.GetTrackName(i));
				wsprintf(data, "%u", bag.GetTrackFreq(i));
				ListView_DoSetItem(hwndlist, i, 2, data);
				wsprintf(data, "%u", bag.GetTrackLen(i));
				ListView_DoSetItem(hwndlist, i, 3, data);
				ListView_DoSetItem(hwndlist, i, 4, bag.GetTrackFile(i));
				totalbytes += bag.GetTrackLen(i);
				totaltracks++;
				i++;
			}
			wsprintf(data, "Total Size = %u bytes", totalbytes);
			SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 1, (LPARAM) data);
			SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 1, (LPARAM) data);
			wsprintf(data, "Number of tracks = %u", totaltracks);
			SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 2, (LPARAM) data);
			SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 2, (LPARAM) data);
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_FILE_WRITE, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_EXTRACT, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_DELETE, MAKELONG(TBSTATE_ENABLED, 0));
			break;
		case ID_FILE_MP3:
			szFile[0] = 0;
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = "MP3 Files (*.mp3)\0*.MP3\0WAVE Files (*.wav)\0*.WAV\0All (*.*)\0*.*\0\0";
			ofn.nFilterIndex = 1;
			ofn.nMaxFileTitle = NULL;
			ofn.lpstrFileTitle = NULL;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Select an audio file to add";
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY; 
			if (GetOpenFileName(&ofn) != TRUE)
				break;
			AddFiles(hwnd, szFile);
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_FILE_WRITE, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_EXTRACT, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_DELETE, MAKELONG(TBSTATE_ENABLED, 0));
			break;
		case ID_FILE_WAV:
			szFile[0] = 0;
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = "WAVE Files (*.wav)\0*.WAV\0RAW PCM Files (*.cmp)\0*.CMP\0MP3 Files (*.mp3)\0*.MP3\0All (*.*)\0*.*\0\0";
			ofn.nFilterIndex = 1;
			ofn.nMaxFileTitle = NULL;
			ofn.lpstrFileTitle = NULL;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Select an audio file to add";
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY; 
			if (GetOpenFileName(&ofn) != TRUE)
				break;
			AddFiles(hwnd, szFile);
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_FILE_WRITE, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_EXTRACT, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_DELETE, MAKELONG(TBSTATE_ENABLED, 0));
			break;
		case ID_FILE_WRITE:
			if (totaltracks == 0) break;
			szFile[0] = 0;
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = "Bag Files (*.bag)\0*.BAG\0All (*.*)\0*.*\0\0";
			ofn.nFilterIndex = 1;
			ofn.nMaxFileTitle = NULL;
			ofn.lpstrFileTitle = NULL;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Save the file as ...";
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY; 
			if (GetSaveFileName(&ofn) != TRUE)
				break;
			if (*(szFile+lstrlen(szFile) - 4) != '.')
			{
				lstrcat(szFile, ".bag");
			}
			if (totalbytes > 2000000)
			{
				if (DialogBox(ghInstance, MAKEINTRESOURCE(IDD_DIALOG1), 
					hwnd, (DLGPROC) DlgProc1) == 1)
					break;
			}
			if (!bag.Write(szFile))
				MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			break;
		case ID_FILE_ADD:
			szFile[0] = 0;
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = "Bag Files (*.bag)\0*.BAG\0All (*.*)\0*.*\0\0";
			ofn.nFilterIndex = 1;
			ofn.nMaxFileTitle = NULL;
			ofn.lpstrFileTitle = NULL;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Select a bag file to add";
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY; 
			if (GetOpenFileName(&ofn) != TRUE)
				break;
			AddFiles(hwnd, szFile);
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_FILE_WRITE, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_EXTRACT, MAKELONG(TBSTATE_ENABLED, 0));
			SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_DELETE, MAKELONG(TBSTATE_ENABLED, 0));
			break;
		case ID_POPUP_REMOVE:
		case ID_EDIT_DELETE:
			if (totaltracks == 0) break;
			if ((i = ListView_DoGetDlgFocus(hwndlist)) == -1) break;
			totalbytes -= bag.GetTrackLen(i);
			totaltracks--;
			if (!bag.Erase(i))
			{
				MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
				break;
			}
			ListView_DeleteItem(hwndlist, i);
			j = ListView_GetItemCount(hwndlist);
			if (j == 0)
			{
				SendMessage(hwndtoolbar, TB_SETSTATE, ID_FILE_WRITE, 0);
				SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_EXTRACT, 0);
				SendMessage(hwndtoolbar, TB_SETSTATE, ID_EDIT_DELETE, 0);
			}
			while (i < j)
			{
				wsprintf(data, "%u", i + 1);
				ListView_DoSetItem(hwndlist, i, 0, data);
				i++;
			}
			wsprintf(data, "Total Size = %u bytes", totalbytes);
			SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 1, (LPARAM) data);
			SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 1, (LPARAM) data);
			wsprintf(data, "Number of tracks = %u", totaltracks);
			SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 2, (LPARAM) data);
			SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 2, (LPARAM) data);
			break;
		case ID_POPUP_EXTRACT:
		case ID_EDIT_EXTRACT:
			if (totaltracks == 0) break;
			if ((i = ListView_DoGetDlgFocus(hwndlist)) == -1) break;

			if (bag.IsMP3(i)) 
				wsprintf(szFile, "%s.mp3", bag.GetTrackName(i));
			else
				wsprintf(szFile, "%s.wav", bag.GetTrackName(i));
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = "All (*.*)\0*.*\0\0";
			ofn.nFilterIndex = 1;
			ofn.nMaxFileTitle = NULL;
			ofn.lpstrFileTitle = NULL;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Save the file as ...";
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY; 
			if (GetSaveFileName(&ofn) != TRUE)
				break;
			if (bag.IsMP3(i))
			{
				if (!bag.Write(szFile, i))
					MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			}
			else if (bag.IsWAV(i))
			{
				if (!bag.WriteWAV(szFile, i))
					MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			}
			else
			{
				if (!bag.Write(szFile, i))
					MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			}
			break;
		case ID_POPUP_EXTRACTASCMP:
		case ID_EDIT_EXTRACTASCMP:
			if (totaltracks == 0) break;
			if ((i = ListView_DoGetDlgFocus(hwndlist)) == -1) break;

			wsprintf(szFile, "%s.cmp", bag.GetTrackName(i));
			ZeroMemory(&ofn, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hwnd;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = "All (*.*)\0*.*\0\0";
			ofn.nFilterIndex = 1;
			ofn.nMaxFileTitle = NULL;
			ofn.lpstrFileTitle = NULL;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Save the file as ...";
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY; 
			if (GetSaveFileName(&ofn) != TRUE)
				break;
			if (!bag.Write(szFile, i))
				MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			break;
		case ID_WINDOW_RESTORE:
			ShowWindow(hwnd, SW_RESTORE);
			break;
		case ID_WINDOW_MAXIMIZE:
			ShowWindow(hwnd, SW_MAXIMIZE);
			break;
		case ID_WINDOW_MINIMIZE:
			ShowWindow(hwnd, SW_MINIMIZE);
			break;
		case ID_WINDOW_EXIT:
			DestroyWindow(hwnd);
			break;
		case ID_HELP_HELP:
			WinHelp(hwnd, "BagTool.hlp", HELP_FINDER, 0);
			break;
		case ID_HELP_ABOUT:
			MessageBox(hwnd, "Bag Tool 0.3\nCopyright (C) 2001 Hoo\nEmail: khchua0@prodigy.net", 
				"About Bag Tool", MB_OK | MB_ICONINFORMATION);
			break;
		}
		break;
	case WM_SIZE:
		if (wParam == SIZE_MINIMIZED)
			break;
		SendMessage(hwndstatus, uMsg, wParam, lParam);
		SendMessage(hwndstatus, SB_GETRECT, (WPARAM) 0, (LPARAM) &rc);
		MoveWindow(hwndlist, 0, 41, LOWORD(lParam), HIWORD(lParam) - rc.bottom - 41, 1);
		if (LOWORD(lParam) > 405)
			ListView_SetColumnWidth(hwndlist, 4, LOWORD(lParam) - 405);
		SendMessage(hwndtoolbar, TB_AUTOSIZE, 0, 0);
		if (wParam == SIZE_MAXIMIZED)
			InvalidateRect(hwnd, NULL, 1);
		break;
	case WM_NOTIFY:
		switch (((LPNMHDR) lParam)->code)
		{
		case TTN_NEEDTEXT:
			lpttt = (LPTOOLTIPTEXT) lParam;
			switch (lpttt->hdr.idFrom)
			{
			case ID_FILE_ADD:
				lpttt->lpszText = stradd;
				break;
			case ID_FILE_READ:
				lpttt->lpszText = strread;
				break;
			case ID_FILE_CLEAR:
				lpttt->lpszText = strclear;
				break;
			case ID_FILE_MP3:
				lpttt->lpszText = strmp3;
				break;
			case ID_FILE_WRITE:
				lpttt->lpszText = strwrite;
				break;
			case ID_EDIT_EXTRACT:
				lpttt->lpszText = strextract;
				break;
			case ID_EDIT_DELETE:
				lpttt->lpszText = strdelete;
				break;
			}
			break;
		case LVN_BEGINDRAG:
			i = ((LPNMLISTVIEW) lParam)->iItem;
			if (!bag.IsMP3(i) && !bag.IsWAV(i))
			{
				MessageBox(hwnd, "Unknown file format", "Bag Tool Error", MB_OK | MB_ICONERROR);
				break;
			}
			DragAcceptFiles(hwnd, FALSE);
			ole.DoDragDrop(i, &bag, MK_LBUTTON);
			DragAcceptFiles(hwnd, TRUE);
			break;
		case LVN_BEGINRDRAG:
			i = ((LPNMLISTVIEW) lParam)->iItem;
			if (!bag.IsMP3(i) && !bag.IsWAV(i))
			{
				MessageBox(hwnd, "Unknown file format", "Bag Tool Error", MB_OK | MB_ICONERROR);
				break;
			}
			DragAcceptFiles(hwnd, FALSE);
			ole.DoDragDrop(i, &bag, MK_RBUTTON);
			DragAcceptFiles(hwnd, TRUE);
			break;
		case NM_DBLCLK:
			i = ((LPNMLISTVIEW) lParam)->iItem;
			if (!bag.IsMP3(i) && !bag.IsWAV(i))
			{
				MessageBox(hwnd, "Unknown file format", "Bag Tool Error", MB_OK | MB_ICONERROR);
				break;
			}
			total = GetTempPath(100, (char *) szFile);
			if (total == 0 || total > 100)
			{
				if (bag.IsMP3(i))
					wsprintf((char *) szFile, "%s.mp3", bag.GetTrackName(i));
				else
					wsprintf((char *) szFile, "%s.wav", bag.GetTrackName(i));
			}
			else
			{
				if (bag.IsMP3(i))
					wsprintf((char *) (szFile + total), "%s.mp3", bag.GetTrackName(i));
				else
					wsprintf((char *) (szFile + total), "%s.wav", bag.GetTrackName(i));
			}
			if (bag.IsMP3(i))
			{
				if (!bag.Write(szFile, i))
				{
					MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
					break;
				}
			}
			else
			{
				if (!bag.WriteWAV(szFile, i))
				{
					MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
					break;
				}
			}
			ShellExecute(NULL, NULL, szFile, NULL, NULL, SW_SHOWNORMAL);
			gDFiles.AddFiles(szFile);
			break;
		case NM_RCLICK:
			iPopup = ((LPNMLISTVIEW) lParam)->iItem;
			if (iPopup < 0 || iPopup > (int) bag.header.track)
				break;
			pt = ((LPNMLISTVIEW) lParam)->ptAction;
			ClientToScreen(hwnd, (LPPOINT) &pt); 
			TrackPopupMenuEx(GetSubMenu(hpopup, 0), TPM_LEFTALIGN | TPM_TOPALIGN | TPM_LEFTBUTTON, 
				pt.x, pt.y + 41, hwnd, NULL);
			break;
		}
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	case WM_MENUSELECT:
		MenuHelp( uMsg, wParam, lParam, GetMenu(hwnd), ghInstance, hwndstatus, gwIDs);
		break;
	default:
		return DefWindowProc(hwnd, uMsg, wParam, lParam);
	}
	return 0;
}

bool AddFiles(HWND hwnd, char * filename)
{
	char data[50];
	unsigned int i, j, total;
	char mp3[] = "mp3";
	char wav[] = "wav";
	char cmp[] = "cmp";

	if (lstrcmpi((char *) (filename + lstrlen(filename) - 3), mp3) == 0)
	{
		if (!add.ReadMP3(filename))
		{
			MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			return false;
		}
	}
	else if (lstrcmpi((char *) (filename + lstrlen(filename) - 3), cmp) == 0)
	{
		if (!add.ReadCMP(filename))
		{
			MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			return false;
		}
	}
	else if (lstrcmpi((char *) (filename + lstrlen(filename) - 3), wav) == 0)
	{
		if (!add.ReadWAV(filename))
		{
			MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			return false;
		}
	}
	else
	{
		if (!add.Read(filename))
		{
			MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
			return false;
		}
	}
	if (!bag.Combine(add))
	{
		MessageBox(hwnd, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
		return false;
	}
	total = add.GetTotalTracks();
	j = ListView_GetItemCount(hwndlist);
	i = 0;
	while (i < total)
	{
		wsprintf(data, "%u", i + j + 1);
		ListView_DoInsertItem(hwndlist, i + j, data);
		ListView_DoSetItem(hwndlist, i + j, 1, add.GetTrackName(i));
		wsprintf(data, "%u", add.GetTrackFreq(i));
		ListView_DoSetItem(hwndlist, i + j, 2, data);
		wsprintf(data, "%u", add.GetTrackLen(i));
		ListView_DoSetItem(hwndlist, i + j, 3, data);
		ListView_DoSetItem(hwndlist, i + j, 4, add.GetTrackFile(i));
		totalbytes += add.GetTrackLen(i);
		totaltracks++;
		i++;
	}
	add.Close();
	wsprintf(data, "Total Size = %u bytes", totalbytes);
	SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 1, (LPARAM) data);
	SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 1, (LPARAM) data);
	wsprintf(data, "Number of tracks = %u", totaltracks);
	SendMessage(hwndstatus, SB_SETTEXT, (WPARAM) 2, (LPARAM) data);
	SendMessage(hwndstatus, SB_SETTIPTEXT, (WPARAM) 2, (LPARAM) data);
	return true;
}

BOOL CALLBACK DlgProc1(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char data[50];

	switch (uMsg)
	{
	case WM_INITDIALOG:
		hwnddlg = hwndDlg;
		hwndprogress = GetDlgItem(hwnddlg, IDC_PROGRESS1);
		hwndedit = GetDlgItem(hwnddlg, IDC_EDIT1);
		wsprintf(data, "0 / %u", totalbytes);
		SendMessage(hwndedit, WM_SETTEXT, (WPARAM) 0, (LPARAM) data);
		SendMessage(hwndprogress, PBM_SETRANGE, (WPARAM) 0, 
			(LPARAM) MAKELPARAM(0, totaltracks));
		SendMessage(hwndprogress, PBM_SETPOS, (WPARAM) 0, (LPARAM) 0);
		SendMessage(hwndprogress, PBM_SETSTEP, (WPARAM) 1, (LPARAM) 0);
		gThreadID = 0;
		hthread = CreateThread(NULL, 0, WriteFunc, (LPVOID) szFile, 0, &gThreadID);
		if (hthread == NULL)
		{
			hwnddlg = NULL;
			EndDialog(hwndDlg, 0);
			return 1;
		}
		return 1;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
		case IDCANCEL:
			hwnddlg = NULL;
			EndDialog(hwndDlg, 1);
			return 1;
		}
		break;
	}
	return 0;
}

BOOL CALLBACK DlgProc2(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char data[50];

	switch (uMsg)
	{
	case WM_INITDIALOG:
		wsprintf(data, "%i", lParam+1);
		SendMessage(GetDlgItem(hwndDlg, IDC_EDIT1), WM_SETTEXT, (WPARAM) 0, (LPARAM) data);
		SendMessage(GetDlgItem(hwndDlg, IDC_EDIT2), WM_SETTEXT, (WPARAM) 0, (LPARAM) bag.data[lParam].name);
		wsprintf(data, "%lu", bag.data[lParam].unknown);
		SendMessage(GetDlgItem(hwndDlg, IDC_EDIT3), WM_SETTEXT, (WPARAM) 0, (LPARAM) data);
		wsprintf(data, "%lu bytes", bag.data[lParam].length);
		SendMessage(GetDlgItem(hwndDlg, IDC_EDIT4), WM_SETTEXT, (WPARAM) 0, (LPARAM) data);
		wsprintf(data, "%lu", bag.data[lParam].freq_khz);
		SendMessage(GetDlgItem(hwndDlg, IDC_EDIT5), WM_SETTEXT, (WPARAM) 0, (LPARAM) data);
		wsprintf(data, "%#x %#x %#x %#x", (BYTE) bag.data[lParam].istart[3], 
			(BYTE) bag.data[lParam].istart[2], (BYTE) bag.data[lParam].istart[1],
			(BYTE) bag.data[lParam].istart[0]);
		SendMessage(GetDlgItem(hwndDlg, IDC_EDIT6), WM_SETTEXT, (WPARAM) 0, (LPARAM) data);
		return 1;
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
		case IDCANCEL:
			EndDialog(hwndDlg, 1);
			return 1;
		}
		break;
	}
	return 0;
}

DWORD WINAPI WriteFunc(LPVOID lpPara)
{
	if (!bag.Write((char *) lpPara))
		MessageBox(NULL, gError, "Bag Tool Error", MB_OK | MB_ICONERROR);
	SendMessage(hwnddlg, WM_COMMAND, (WPARAM) IDOK, (LPARAM) 0);
	hwnddlg = NULL;
	return 0;
}

int ListView_DoInsertColumn(HWND hwnd, int iInsertBefore, int nWidth, LPSTR lpsz) 
{ 
    LV_COLUMN lvci; 
    int index; 
 
    lvci.mask = LVCF_TEXT | LVCF_WIDTH;
    lvci.pszText = lpsz; 
    lvci.cx = nWidth; 
    lvci.cchTextMax = lstrlen(lvci.pszText); 
 
    index = SendMessage(hwnd, LVM_INSERTCOLUMN, (WPARAM) iInsertBefore, (LPARAM) &lvci); 
    return index; 
} 

int ListView_DoInsertItem(HWND hwnd, int iInsertBefore, LPSTR lpsz)
{
	LV_ITEM lvi;
	int index;

	lvi.mask = LVIF_TEXT;
	lvi.iItem = iInsertBefore;
	lvi.iSubItem = 0;
    lvi.pszText = lpsz; 
    lvi.cchTextMax = lstrlen(lvi.pszText);

	index = SendMessage(hwnd, LVM_INSERTITEM, (WPARAM) 0, (LPARAM) &lvi);
	return index;
}

int ListView_DoSetItem(HWND hwnd, int iInsertBefore, int iSubItem, LPSTR lpsz)
{
	LV_ITEM lvi;
	int index;

	lvi.mask = LVIF_TEXT;
	lvi.iItem = iInsertBefore;
	lvi.iSubItem = iSubItem;
    lvi.pszText = lpsz; 
    lvi.cchTextMax = lstrlen(lvi.pszText);

	index = SendMessage(hwnd, LVM_SETITEM,	(WPARAM) 0, (LPARAM) &lvi);
	return index;
}

long ListView_DoGetDlgFocus(HWND hwnd)
{
	long i = SendMessage(hwnd, LVM_GETTOPINDEX, (WPARAM) 0, (LPARAM) 0);
	long total = i + SendMessage(hwnd, LVM_GETCOUNTPERPAGE, (WPARAM) 0, (LPARAM) 0); 
	UINT mask = LVIS_FOCUSED;
	long j = i;
	while (j < total)
	{
		if (SendMessage(hwnd, LVM_GETITEMSTATE, (WPARAM) j, (LPARAM) mask))
			return j;
		j++;
	}
	return -1;
}