// Ole.cpp: implementation of the Ole class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Ole.h"

extern char gError[100];
extern DeleteFiles gDFiles;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BagToolDS::BagToolDS()
{
	count = 0;
}

BagToolDS::~BagToolDS()
{
}

HRESULT BagToolDS::GiveFeedback(DWORD dwEffect)
{
	return DRAGDROP_S_USEDEFAULTCURSORS;
}

HRESULT BagToolDS::QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState)
{
	if (fEscapePressed)
		return DRAGDROP_S_CANCEL;

	if (!(grfKeyState & mousekey))
		return DRAGDROP_S_DROP;
	
	return S_OK;
}

HRESULT BagToolDS::QueryInterface (REFIID riid, LPVOID FAR* ppv)
{
	if (riid == IID_IUnknown  || riid == IID_IDropSource)
	{
		AddRef();
		*ppv=this;
		return S_OK;
	}
	return E_NOINTERFACE;
}

BagToolEF::BagToolEF()
{
	max = 2;

	gelt[0].cfFormat = RegisterClipboardFormat(CFSTR_FILEDESCRIPTOR);
	gelt[0].dwAspect = DVASPECT_CONTENT;
	gelt[0].lindex = -1;
	gelt[0].ptd = NULL;
	gelt[0].tymed = TYMED_HGLOBAL;

	gelt[1].cfFormat = RegisterClipboardFormat(CFSTR_FILECONTENTS);
	gelt[1].dwAspect = DVASPECT_CONTENT;
	gelt[1].lindex = -1;
	gelt[1].ptd = NULL;
	gelt[1].tymed = TYMED_HGLOBAL | TYMED_ISTREAM;

	index = 0;
	count = 0;
}

BagToolEF::~BagToolEF()
{
}

HRESULT BagToolEF::Next(ULONG celt, FORMATETC * rgelt, ULONG * pceltFetched)
{
	if (index + celt > max)
	{
		if (index < max)
		{
			memcpy((void *) rgelt, &gelt[index], sizeof(FORMATETC)*(max - index));
			if (pceltFetched != NULL)
				*pceltFetched = max - index;
			index = max;
			return S_FALSE;
		}
		if (pceltFetched != NULL)
			*pceltFetched = 0;
		return S_FALSE;
	}
	if (celt == 1)
	{
		if (pceltFetched != NULL)
			*pceltFetched = 1;
		memcpy((void *) rgelt, &gelt[index], sizeof(FORMATETC));
		index++;
		return S_OK;
	}
	memcpy((void *) rgelt, &gelt[index], sizeof(FORMATETC)*celt);
	index+=celt;
	if (pceltFetched != NULL)
		*pceltFetched = celt;
	return S_OK;
}

HRESULT BagToolEF::Skip(ULONG celt)
{
	index += celt;
	if (index >= max)
	{
		index = max;
		return S_FALSE;
	}
	return S_OK;
}

HRESULT BagToolEF::Reset(void)
{
	index = 0;
	return S_OK;
}

HRESULT BagToolEF::Clone(IEnumFORMATETC ** ppenum)
{
	return E_UNEXPECTED;
}

HRESULT BagToolEF::QueryInterface (REFIID riid, LPVOID FAR* ppv)
{
	if (riid == IID_IUnknown || riid == IID_IEnumFORMATETC)
	{
		AddRef();
		*ppv=this;
		return S_OK;
	}
	return E_NOINTERFACE;
}

BagToolDO::BagToolDO()
{
	BGef = BagToolEF::Create();
	BGef->AddRef();
	count = 0;
}

BagToolDO::~BagToolDO()
{
	BGef->Release();
}

BagToolDO FAR * BagToolDO::Create(bool bOleInit, Ole * parentole)
{
	BagToolDO FAR * lpDO = new BagToolDO;
	lpDO->bOleInitialized = bOleInit;
	lpDO->ole = parentole;

	return lpDO;
}

HRESULT BagToolDO::GetData(FORMATETC * pFormatetc, STGMEDIUM * pmedium)
{
	HGLOBAL hMem;
	LPVOID hVoid;

	if (!bOleInitialized)
		return OLE_E_NOTRUNNING;

	if (pFormatetc->cfFormat == BGef->gelt[0].cfFormat)
	{
		if (pFormatetc->lindex != -1)
			return DV_E_LINDEX;
		if (pFormatetc->dwAspect != DVASPECT_CONTENT)
			return DV_E_DVASPECT;
		if (pFormatetc->tymed & TYMED_HGLOBAL == 0)
			return DV_E_TYMED;

		pmedium->tymed = TYMED_HGLOBAL;
		pmedium->hGlobal = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sizeof(FILEGROUPDESCRIPTORA));
		if (pmedium->hGlobal == NULL)
			return STG_E_MEDIUMFULL;
		hVoid = GlobalLock(pmedium->hGlobal);
		if (hVoid == NULL)
		{
			GlobalFree(pmedium->hGlobal);
			return STG_E_MEDIUMFULL;
		}
		memcpy(hVoid, &(ole->fdd), sizeof(FILEGROUPDESCRIPTORA));
		GlobalUnlock(pmedium->hGlobal);
		pmedium->pUnkForRelease = NULL;
		return S_OK;
	}

	if (pFormatetc->cfFormat == BGef->gelt[1].cfFormat)
	{
		if (pFormatetc->lindex > 0)
			return DV_E_LINDEX;
		if (pFormatetc->dwAspect != DVASPECT_CONTENT)
			return DV_E_DVASPECT;
		if (pFormatetc->tymed & TYMED_ISTREAM)
		{
			pmedium->tymed = TYMED_ISTREAM;
			hMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, ole->filesize);
			if (hMem == NULL)
				return STG_E_MEDIUMFULL;
			if (WriteMemory(hMem) != S_OK)
			{
				GlobalFree(hMem);
				return STG_E_MEDIUMFULL;
			}
			if (CreateStreamOnHGlobal(hMem, TRUE, &(pmedium->pstm)) != S_OK)
			{
				GlobalFree(hMem);
				return STG_E_MEDIUMFULL;
			}
			pmedium->pUnkForRelease = NULL;
			return S_OK;
		}
		if (pFormatetc->tymed & TYMED_HGLOBAL)
		{
			pmedium->tymed = TYMED_HGLOBAL;
			pmedium->hGlobal = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, ole->filesize);
			if (pmedium->hGlobal == NULL)
				return STG_E_MEDIUMFULL;
			if (WriteMemory(pmedium->hGlobal) != S_OK)
			{
				GlobalFree(pmedium->hGlobal);
				return STG_E_MEDIUMFULL;
			}
			pmedium->pUnkForRelease = NULL;
			return S_OK;
		}
		return DV_E_TYMED;
	}

	pmedium->tymed = TYMED_NULL;
	pmedium->pUnkForRelease = NULL;
	pmedium->hGlobal = NULL;
	return DV_E_FORMATETC;
}

HRESULT BagToolDO::WriteMemory(HGLOBAL hMem)
{
	LPVOID hVoid = GlobalLock(hMem);
	if (hVoid == NULL)
	{
		return STG_E_MEDIUMFULL;
	}
	if (ole->BG->IsMP3(ole->index))
	{
		if (!ole->BG->WriteMemory(hVoid, ole->index))
		{
			GlobalUnlock(hMem);
			return STG_E_MEDIUMFULL;
		}
	}
	else
	{
		if (!ole->BG->WriteWAVMemory(hVoid, ole->index))
		{
			GlobalUnlock(hMem);
			return STG_E_MEDIUMFULL;
		}
	}
	GlobalUnlock(hMem);
	return S_OK;
}

HRESULT BagToolDO::GetDataHere(FORMATETC * pFormatetc, STGMEDIUM * pmedium)
{
	if (!bOleInitialized)
		return OLE_E_NOTRUNNING;

	return DV_E_FORMATETC;
}

HRESULT BagToolDO::QueryGetData(FORMATETC * pFormatetc)
{
	unsigned int i;

	if (!bOleInitialized)
		return OLE_E_NOTRUNNING;

	i = 0;
	while (i < BGef->max)
	{
		if ((pFormatetc->cfFormat == BGef->gelt[i].cfFormat) &&
			(pFormatetc->dwAspect == BGef->gelt[i].dwAspect) &&
			(pFormatetc->ptd == BGef->gelt[i].ptd) &&
			(pFormatetc->tymed & BGef->gelt[i].tymed))
		{
			return S_OK;
		}
		i++;
	}
	return DV_E_FORMATETC;
}

HRESULT BagToolDO::EnumFormatEtc(DWORD dwDirection, IEnumFORMATETC ** ppenumFormatetc)
{
	IEnumFORMATETC * penumFormatetc;

	if (dwDirection == DATADIR_SET)
		return E_NOTIMPL;

	BGef->QueryInterface(IID_IEnumFORMATETC, (LPVOID *) &penumFormatetc);
	*ppenumFormatetc = penumFormatetc;

	return S_OK;
}

HRESULT BagToolDO::QueryInterface (REFIID riid, LPVOID FAR* ppv)
{
	if (riid == IID_IUnknown || riid == IID_IDataObject)
	{
		AddRef();
		*ppv=this;
		return S_OK;
	}
	return E_NOINTERFACE;
}

Ole::Ole()
{
	data = new char[200];
	memset((void *) data, 0, 200);

	filename = new char[256];
	memset((void *) filename, 0, 256);
	filesize = 0;

	bOleInitialized = false;
	pvReserved = NULL;
}

Ole::~Ole()
{
	if (data != NULL)
		delete [] data;

	if (filename != NULL)
	{
		if (lstrlen(filename) != 0)
		{
			DeleteFile(filename);
			filename[0] = 0;
		}
		delete [] filename;
	}

	if (bOleInitialized)
		OleUninitialize();

	delete BGds;
}

bool Ole::Initialize()
{
	if (S_OK == OleInitialize(pvReserved))
		bOleInitialized = true;
	else
		bOleInitialized = false;

	BGds = new BagToolDS;

	return bOleInitialized;
}

bool Ole::DoDragDrop(unsigned int i, BagGlue * bag, DWORD mousekey)
{
	DWORD dwDropEffect;
	LPDATAOBJECT ppv;
	
	index = i;
	BG = bag;
	BGds->mousekey = mousekey;

	if (BG->IsMP3(index))
	{
		wsprintf((char *) filename, "%s.mp3", BG->GetTrackName(index));
		filesize = BG->GetTrackLen(index);
	}
	else
	{
		wsprintf((char *) filename, "%s.wav", BG->GetTrackName(index));
		filesize = BG->GetTrackLen(index) + 44;
	}

	fdd.cItems = 1;
	fdd.fgd[0].dwFlags = FD_FILESIZE | FD_WRITESTIME | FD_CREATETIME | FD_ACCESSTIME | FD_ATTRIBUTES;
	fdd.fgd[0].nFileSizeLow = filesize;
	fdd.fgd[0].nFileSizeHigh = 0;
	GetSystemTimeAsFileTime(&(fdd.fgd[0].ftLastWriteTime));
	GetSystemTimeAsFileTime(&(fdd.fgd[0].ftLastAccessTime));
	GetSystemTimeAsFileTime(&(fdd.fgd[0].ftCreationTime));
	fdd.fgd[0].dwFileAttributes = FILE_ATTRIBUTE_NORMAL;
	lstrcpy(fdd.fgd[0].cFileName, filename);

	BGdo = BagToolDO::Create(bOleInitialized, this);
	BGdo->QueryInterface(IID_IDataObject, (LPVOID *) &ppv);

	::DoDragDrop(ppv, BGds, DROPEFFECT_COPY | DROPEFFECT_MOVE, 
		&dwDropEffect);
	
	BGdo->Release();
	return true;
}