// BagGlue.h: interface for the BagGlue class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(BAGGLUE_H)
#define BAGGLUE_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define BAGDATA_DEFAULTSIZE 100

struct BAGHEADER
{
	char fileID[8];	//	should be GABA 4
	DWORD track;	//	number of tracks
	DWORD unknown;	//	unknown 40
};

struct BAGDATA
{
	char name[32];	//	music name
	DWORD location;	//	music location in the file
	DWORD length;	//	music length
	DWORD freq_khz;	//	music frequency kHz
	DWORD unknown;	//	25 = 128bit mp3		24 = 64bit mp3		06 = wave
	char istart[4];	//	starting 4 bytes in reverse
	char zero[12];	//	12 zeros

	char filename[100];	//	Track the filename
};

struct RIFFWAVE
{
	char riff[4];	//	"RIFF"
	DWORD length;	//	file length - 8
	char wavefmt[8];//	"WAVEfmt "
	DWORD fmtlength;//	0x00000010
	WORD pcm;		//	0x0001
	WORD stereo;	//	0x0002
	DWORD rate;		//	22050
	DWORD data1;	//	byte per second
	WORD data2;		//	block align
	WORD data3;		//	sample bit
	char data[4];	//	"data"
	DWORD datalength;
};

class BagGlue  
{
public:
	BagGlue(unsigned int size);
	virtual ~BagGlue();

	bool Read(char * filename);
	bool ReadMP3(char * filename);
	bool ReadCMP(char * filename);
	bool ReadWAV(char * filename);
	bool Write(char * filename);
	bool Write(char * filename, unsigned int index);
	bool WriteWAV(char * filename, unsigned int index);
	bool Close();

	bool WriteMemory(void * hMem, unsigned int index);
	bool WriteWAVMemory(void * hMem, unsigned int index);

	bool Combine(BagGlue & bg);
	bool Erase(unsigned int index);
	bool Erase(unsigned int * tracks, unsigned int count);
	DWORD GetData(HFILE hfile, char * buffer, DWORD length);
	DWORD GetCacheData(HFILE hfile, char * buffer, DWORD length);
	void FlushCache();

	unsigned int GetTotalTracks();
	char * GetTrackName(unsigned int index);
	unsigned int  GetTrackFreq(unsigned int index);
	unsigned int  GetTrackLen(unsigned int index);
	char * GetTrackFile(unsigned int index);

	bool CopyDirectory(char ** tempfilename, char * filename);
	bool IsMP3(unsigned int index);
	bool IsWAV(unsigned int index);

	BAGHEADER header;

	unsigned int ndata;
	BAGDATA * data;

	DWORD cacheindex;
	DWORD cacheBytesRead;
	char cache[64];

};

#endif // !defined(BAGGLUE_H)
